<?php

namespace Selective\ImageType\Detector;

use Selective\ImageType\ImageFormat;
use Selective\ImageType\ImageType;
use Selective\ImageType\MimeType;
use SplFileObject;

/**
 * Detector.
 */
final class BmpDetector implements DetectorInterface
{
    /**
     * BMP identification.
     *
     * @param SplFileObject $file The image file
     *
     * @return ImageType|null The image type
     */
    public function detect(SplFileObject $file): ?ImageType
    {
        return $file->fread(2) === 'BM' ? new ImageType(ImageFormat::BMP, MimeType::IMAGE_BMP) : null;
    }
}
